/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.util.preferences;

import com.aptana.core.util.replace.SimpleTextPatternReplacer;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.util.Key;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPreferencesReader {
    public static final char DELIMITER = '\u0005';
    private static final SimpleTextPatternReplacer TAG_REPLACER = new SimpleTextPatternReplacer();
    public static final String STRING_DEFAULT = "";

    static {
        TAG_REPLACER.addPattern("&amp;", "&");
        TAG_REPLACER.addPattern("&apos;", "'");
        TAG_REPLACER.addPattern("&quot;", "\"");
        TAG_REPLACER.addPattern("&lt;", "<");
        TAG_REPLACER.addPattern("&gt;", ">");
    }

    public static String getUnEscaped(String s) {
        return TAG_REPLACER.searchAndReplace(s);
    }

    private static Map read(NodeList nl) {
        HashMap<String, Object> map = new HashMap<String, Object>(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.hasChildNodes()) {
                if (n.getFirstChild().getNodeType() == 3) {
                    map.put(n.getNodeName(), XMLPreferencesReader.getUnEscaped(n.getFirstChild().getNodeValue()));
                } else {
                    map.put(n.getNodeName(), XMLPreferencesReader.read(n.getChildNodes()));
                }
            }
            ++i;
        }
        return map;
    }

    private static Map read(String str) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(str.getBytes()));
            return XMLPreferencesReader.read(doc.getChildNodes());
        }
        catch (Exception e) {
            PHPEplPlugin.logError("Unexpected exception", e);
            return null;
        }
    }

    public static Map[] read(IPreferenceStore store, String prefsKey) {
        ArrayList<Map> maps = new ArrayList<Map>();
        StringTokenizer st = new StringTokenizer(store.getString(prefsKey), new String(new char[]{'\u0005'}));
        while (st.hasMoreTokens()) {
            maps.add(XMLPreferencesReader.read(st.nextToken()));
        }
        return maps.toArray(new HashMap[maps.size()]);
    }

    public static Map[] read(Preferences store, String prefsKey) {
        String storedValue = store.getString(prefsKey);
        return XMLPreferencesReader.getHashFromStoredValue(storedValue);
    }

    public static Map[] read(Key prefKey, ProjectScope projectScope, IWorkingCopyManager workingCopyManager) {
        String storedValue = prefKey.getStoredValue((IScopeContext)projectScope, workingCopyManager);
        if (storedValue == null) {
            storedValue = STRING_DEFAULT;
        }
        return XMLPreferencesReader.getHashFromStoredValue(storedValue);
    }

    public static Map[] getHashFromStoredValue(String storedValue) {
        ArrayList<Map> maps = new ArrayList<Map>();
        StringTokenizer st = new StringTokenizer(storedValue, new String(new char[]{'\u0005'}));
        while (st.hasMoreTokens()) {
            maps.add(XMLPreferencesReader.read(st.nextToken()));
        }
        return maps.toArray(new HashMap[maps.size()]);
    }
}

